IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_INTEGRA_PACOTES_EVENTOS]'))
DROP VIEW [DBO].[V_INTEGRA_PACOTES_EVENTOS]    
GO
CREATE VIEW [dbo].[V_INTEGRA_PACOTES_EVENTOS]  
AS  
SELECT   
P.ID AS ID_PACOTE,  
E.TABELA,  
E.HR_EVENTO AS DT_CAD,  
ISNULL(P.ST_PACOTE,0) AS ST_PACOTE,  
P.DT_ULT_ALT,  
E.ID AS ID_EVENTO,  
E.CD_EMP,  
E.CD_FILIAL,  
E.CD_CTR,  
E.TP_EVENTO,  
E.HR_EVENTO,  
E.ST_EVENTO,
CASE WHEN TP_EVENTO=1 THEN
	'INSERCAO'
WHEN TP_EVENTO=2 THEN
    'ALTERACAO'
Else
    'DELETAR'
END AS DS_TP_EVENTO,
CASE WHEN ST_EVENTO=1 then
    'ENTREGUE'
Else
    'PENDENTE'
END DS_ST_EVENTO,
ISNULL(E.CD_USU,0) AS CD_USU,
ISNULL(U.NM_USU,'') AS NM_USU,
E.DT_ULT_ALT AS DT_ULT_ALT_EVENTO
FROM  
INTEGRA_EVENTOS E  
LEFT OUTER JOIN INTEGRA_PACOTES_EVENTOS PE ON E.ID   = PE.ID_EVENTO
LEFT OUTER  JOIN INTEGRA_PACOTES P ON P.ID  = PE.ID_PACOTE
LEFT OUTER JOIN GLB_USU U ON
E.CD_USU = U.CD_USU 